# Descriptive_freq.R
# Frequency distribution for the elytra data

# Load necessary libraries
library(gmodels)

# Read in data set
elytra <- read.table(header=T,colClasses=c("character","numeric"),text="
sex  length
M	4.9
F	5.2
M	4.9
F	4.2
F	5.7
M	4.6
M	3.8
F	5.4
F	4.0
F	4.5
M	4.9
F	5.2
M	4.9
F	4.2
F	5.7
M	4.6
M	3.8
F	5.4
F	4.0
F	4.5
F	5.2
F	4.9
M	5.0
M	4.4
M	5.0
M	5.0
M	4.9
F	4.5
F	4.5
M	5.1
F	5.5
M	4.8
F	4.9
M	4.8
M	4.5
M	4.5
M	4.4
M	5.2
M	4.1
F	5.0
M	4.4
F	4.9
M	4.7
M	4.4
F	4.8
F	4.5
M	4.0
M	3.4
F	5.5
M	4.7
M	4.8
F	4.8
F	3.7
M	5.3
M	4.6
F	4.8
M	4.5
M	5.0
M	4.4
F	4.6
M	4.4
M	4.9
F	5.3
F	5.0
F	4.7
F	5.2
M	5.0
M	5.0
M	4.8
M	5.8
F	5.7
F	5.2
M	4.9
F	5.1
F	5.3
F	5.3
F	5.9
F	5.3
M	4.5
F	5.2
M	5.1
F	4.6
M	4.8
M	3.5
F	4.6
F	5.3
M	5.2
F	4.8
M	5.1
M	5.2
M	4.9
M	5.3
M	5.2
F	4.9
F	5.6
M	5.0
M	5.0
F	5.1
M	5.1
F	5.5
M	5.1
F	4.8
F	4.9
F	5.0
M	4.9
M	5.0
F	5.0
M	4.9
M	4.8
F	5.2
F	4.8
M	4.7
F	5.1
M	4.5
M	5.0
F	5.4
F	4.6
M	4.0
M	4.2
F	5.2
F	4.6
M	5.0
M	3.7
M	4.6
M	4.0
M	5.1
F	4.4
M	4.8
M	4.6
F	3.7
")

# Classify insects into two groups by size
elytra$size <- ifelse(elytra$length<5.0,"small","large")

# Print the data
elytra

# Tabulate data into frequencies
CrossTable(elytra$sex,elytra$size)

